from __future__ import generators
import plus
import Arenas
import random
import Hazards
import math

import HazardsBlueRay
from random import randint


class BBEANS_2(Arenas.SuperArena):
    "The official arena for BBEANS AI tournaments, second version.  This arena starts out harmless enough, but after 40 seconds the walled spinning blade in the middle will be exposed, and after another 40 seconds the corner flippers will activate."
    name = "BBEANS Tournament Arena V2"
    preview = "bbeans/bbeans2_preview.bmp"
    game_types = ['DEATHMATCH', 'BATTLE ROYAL', 'TEAM MATCH']
    extent = (-12, 12, 12, -12)
    #Original numbers for 1 minute and 2 minute hazard activation are 247 and 493

    def __init__(self):
        #Regular arena start points
        Arenas.SuperArena.__init__(self, "Arenas/bbeans/bbeans2.gmf")
        
        #Start points for team 1 = multibot
        #Arenas.SuperArena.__init__(self, "Arenas/bbeans/bbeans2_p1multi.gmf")

        #Start points for team 2 = multibot
        #Arenas.SuperArena.__init__(self, "Arenas/bbeans/bbeans2_p2multi.gmf")
        
        plus.setBackColor(0,0,0)
        degrad = 0.01745
        self.AddStaticCamera("                Overview", (16, 8, -16), (30*degrad,315*degrad), 50*degrad)
        self.AddStaticCamera("                Overview 2", (-16, 8, 16), (30*degrad,135*degrad), 50*degrad)
        self.AddWatchCamera("                Watch Cam 1", (15, 7.8, -15), (6, 37, 40*degrad, 15*degrad))
        self.AddWatchCamera("                Watch Cam 2", (-15, 7.8, 15), (6, 37, 40*degrad, 15*degrad))
        self.AddWatchCamera("                Blade Cam", (0, 2, 0), (5, 25, 65*degrad, 45*degrad))
        self.AddWatchCamera("                Overhead Cam", (0, 7.8, 0), (10, 15, 68*degrad, 58*degrad))
        self.AddWatchCamera("                Audience Cam", (0, 3, -30), (19, 41, 30*degrad, 20*degrad))
        self.players = ()
        self.SetPinned ("bladewall", True)
        self.wallmaster = 0
        self.floormaster = 0
        self.player1inne = 0
        self.player2inne = 0
        self.player3inne = 0
        self.player4inne = 0
        self.player1inse = 0
        self.player2inse = 0
        self.player3inse = 0
        self.player4inse = 0
        self.player1insw = 0
        self.player2insw = 0
        self.player3insw = 0
        self.player4insw = 0
        self.player1innw = 0
        self.player2innw = 0
        self.player3innw = 0
        self.player4innw = 0
        self.botinne = 0
        self.nefliptimer = 0
        self.botinse = 0
        self.sefliptimer = 0
        self.botinsw = 0
        self.swfliptimer = 0
        self.botinnw = 0
        self.nwfliptimer = 0
        self.flipperpower = 1250
        self.flippersound = plus.createSound("Sounds/hellraiser_trigger.wav", False, (0, 0, 0))
        self.flippersound2 = plus.createSound("Sounds/hzd_comp_fire.wav", False, (0, 0, 0))
        self.activatesound = plus.createSound("Sounds/start_scoring.wav", False, (0, 0, 0))
        self.warningsound = plus.createSound("Sounds/stop_scoring.wav", False, (0, 0, 0))
        self.retractsound = plus.createSound("Sounds/bbeans/liftmotor.wav", False, (0, 0, 0))

        #Red flipper indicator lights
        self.AddXtra("Obstacle", "arenas\\bbeans\\redlights.gmf", "metal")

            ##################  BotFlame ##################-------------
        self.SetDefaultstimer = 0
        self.RI_OffOrOn = 0
        self.RI_1 = 0
        self.RI_2 = 0
        self.RI_3 = 0
        self.RI_4 = 0
        self.RI_5 = 0
        self.RI_6 = 0
        self.BOT_0 = False
        self.BOT_1 = False
        self.BOT_2 = False
        self.BOT_3 = False

       ## ----------- ADJUSTABLE SETTINGS ----------- ##
        self.FrequencyOfBotFire = 5 # Determines how often Bot Fires will occur:   '0' = BotFlames off.     '1' = every game.     '2' = 1 out of every 2 games (average).    Etc......
        self.DamageUntilFlame_a = .2  # Parameters are above 0(dead) and below 1(no damage).  Negative number turns Bot flame 'a' Off.
        self.DamageUntilFlame_b = .1   # Another flame in case of greater damage. Parameters are above 0(dead) and below 1(no damage).  Negative number turns Bot flame 'b' Off.
        self.FireDamageON = False  # 'True' causes fire to damage bot itself.  'False' turns off.
        self.FireDamageAmount = 5  # Determines how much damage the fire does each Tick.
        self.FireSoundON = False  # 'True' turns on 'crackling fire' sound.  'False' turns off.
       ## ----------- ADJUSTABLE SETTINGS ----------- ##
            ##################  BotFlame ##################-------------

    def Activate(self, on):
        if on:
            self.players = plus.getPlayers()

        Arenas.SuperArena.Activate(self, on)
        
    def HazardsOn(self, on):
        self.spinner = self.GetHinge("Hinge01")
        self.spinner.SetAutoLocks(False, False)
        self.spinner.Lock(False)

        self.prism = self.AddPrismatic("floor", "bladewall", 0, -1, 0, 0, 3, 0)
        self.prism.SetAutoLock(False)

        self.neflipper = self.GetHinge("Hinge02")
        self.neflipper.SetAutoLocks(False, False)
        self.neflipper.Lock(True)

        self.seflipper = self.GetHinge("Hinge03")
        self.seflipper.SetAutoLocks(False, False)
        self.seflipper.Lock(True)

        self.swflipper = self.GetHinge("Hinge04")
        self.swflipper.SetAutoLocks(False, False)
        self.swflipper.Lock(True)

        self.nwflipper = self.GetHinge("Hinge05")
        self.nwflipper.SetAutoLocks(False, False)
        self.nwflipper.Lock(True)

        if on:
            self.SetSubMaterialSound("blade", "metal", 1.2, "Sounds/bbeans/spinnerhit.wav")
            # check if this is a LW battle; if so, cut spinner power
            if plus.getWeight(0) > 250 or plus.getWeight(1) > 250 or plus.getWeight(2) > 250 or plus.getWeight(3) > 250:
                self.spinner.SetPowerSettings(200,68)
            else:
                self.spinner.SetPowerSettings(100,68)
            self.spinner.SetDirection(100)
        else:
            self.wallmaster = 164
            self.SetPinned ("neflipper", True)
            self.SetPinned ("seflipper", True)
            self.SetPinned ("swflipper", True)
            self.SetPinned ("nwflipper", True)

        #box off spinner
        self.AddCollisionLine((2, 2), (2, -2))
        self.AddCollisionLine((2, -2), (-2, -2))
        self.AddCollisionLine((-2, -2), (-2, 2))
        self.AddCollisionLine((-2, 2), (2, 2))
        #fence
        self.AddCollisionLine((-10, 12), (10, 12))
        self.AddCollisionLine((10, 12), (12, 10))
        self.AddCollisionLine((12, 10), (12, -10))
        self.AddCollisionLine((12, -10), (10, -12))
        self.AddCollisionLine((10, -12), (-10, -12))
        self.AddCollisionLine((-10, -12), (-12, -10))
        self.AddCollisionLine((-12, -10), (-12, 10))
        self.AddCollisionLine((-12, 10), (-10, 12))
        #spinner ai guide
        self.AddPOV(0, (5, 5), (0, 1))
        self.AddPOV(1, (5, -5), (1, 2))
        self.AddPOV(2, (-5, -5), (2, 3))
        self.AddPOV(3, (-5, 5), (3, 0))

        self.AddPOV(0, (5, 5), (0, 3))
        self.AddPOV(1, (5, -5), (1, 0))
        self.AddPOV(2, (-5, -5), (2, 1))
        self.AddPOV(3, (-5, 5), (3, 2))

            ##################  BotFlame ##################-------------
        self.flame0a = HazardsBlueRay.BotFlame((0, 0, 0), (0, 1, 0), (.2, .4, .2), .8) 
        self.AddHazard(self.flame0a)                                                                    
        self.flame1a = HazardsBlueRay.BotFlame((0, 0, 0), (0, 1, 0), (.2, .4, .2), .8) 
        self.AddHazard(self.flame1a)                                                                    
        self.flame2a = HazardsBlueRay.BotFlame((0, 0, 0), (0, 1, 0), (.2, .4, .2), .8) 
        self.AddHazard(self.flame2a)
        self.flame3a = HazardsBlueRay.BotFlame((0, 0, 0), (0, 1, 0), (.2, .4, .2), .8) 
        self.AddHazard(self.flame3a)                                                                    

        self.flame0b = HazardsBlueRay.BotFlame((0, 0, 0), (0, 1, 0), (.2, .4, .2), .8) 
        self.AddHazard(self.flame0b)
        self.flame1b = HazardsBlueRay.BotFlame((0, 0, 0), (0, 1, 0), (.2, .4, .2), .8) 
        self.AddHazard(self.flame1b)
        self.flame2b = HazardsBlueRay.BotFlame((0, 0, 0), (0, 1, 0), (.2, .4, .2), .8) 
        self.AddHazard(self.flame2b)
        self.flame3b = HazardsBlueRay.BotFlame((0, 0, 0), (0, 1, 0), (.2, .4, .2), .8) 
        self.AddHazard(self.flame3b)            

        #self.Crackle = plus.createSound("Sounds/Crackling-short.wav", True, (0,0,0)) # Indicator.
        self.Crackle = plus.createSound("Sounds/Crackling-short-quiet.wav", True, (0,0,0)) # Indicator.
            ##################  BotFlame ##################-------------

        return Arenas.SuperArena.HazardsOn(self, on)

    def __del__(self):
        plus.removeSound(self.Crackle)
        Arenas.SuperArena.__del__(self)

            ##################  BotFlame ##################-------------
    def Introduction(self):
        # set initial camera & fade from black
        plus.setCameraPosition(8,6,-8)
        plus.setCameraRotation(0.9,-1.57)
        plus.setCameraFOV(0.9)
        plus.fadeFromBlack(0.01)
        
        # self.crowd = plus.createSound("Sounds/crowd/LoudCheer_Loop.wav", False, (0,0,0))
        # plus.loopSound(self.crowd)
        # yield .25
        
        players = plus.getPlayers()
        pcount = len(players)
        
        if 0 in players:
            self.BOT_0 = True
            #bot 1 cam
            plus.animateCamera((8,6,-8), (0.9,-1.57), 0.9, (-2.5,2,-2.5), (0.525,-3.569), 0.7, 0, 6)
            yield 7
            
        if 1 in players:
            self.BOT_1 = True
            #bot 2 cam
            plus.animateCamera((-8,6,8), (0.9,1.57), 0.9, (2.5,2,2.5), (0.525,-0.427), 0.7, 0, 6)
            yield 7
            
        if 2 in players:
            self.BOT_2 = True
            #bot 3 cam
            plus.animateCamera((-8,6,-8), (0.9,0), 0.9, (-2.5,2,2.5), (0.525,-2), 0.7, 0, 6)
            yield 7
            
        if 3 in players:
            self.BOT_3 = True
            #bot 4 cam
            plus.animateCamera((8,6,8), (0.9,3.14159), 0.9, (2.5,2,-2.5), (0.525,1.143), 0.7, 0, 6)
            yield 7
            
        #fade out
        # plus.fadeOutLoop(self.crowd, 2000)
        # yield 2
            
        # done
        yield 0            
            ##################  BotFlame ##################-------------

    def Tick(self):
        if self.wallmaster < 270:
            self.wallmaster += 1

        if self.bHazardsOn:
            if self.floormaster < 500:
                self.floormaster += 1

        for each in self.players:
            #If bots are outside the fence eliminate them, but leave some 'grace area'
            if plus.getLocation(each)[1] < -0.3 and (abs(plus.getLocation(each)[0]) > 12.3 or abs(plus.getLocation(each)[2]) > 12.3):
                plus.eliminatePlayer(each)

            #If bots get flipped into the blade, lower the wall
            if abs(plus.getLocation(each)[0]) < 1.8 and abs(plus.getLocation(each)[2]) < 1.8 and plus.getLocation(each)[1] < -0.5 and self.wallmaster < 164:
                self.wallmaster = 164

        #After 1 minute lower the wall
        if self.wallmaster == 164:
            plus.playSound(self.retractsound)
        if self.wallmaster > 164 and self.wallmaster < 184:
            self.SetPinned ("bladewall", False)
            self.prism.Lock(False)
            self.prism.ApplyForce(50)

        #Create new collision lines when flippers are about to activate
        if self.floormaster == 309:
            #Change indicator lights to yellow
            plus.playSound(self.warningsound)
            self.AddXtra("Obstacle", "arenas\\bbeans\\greenlights.gmf", "metal")

            self.AddCollisionLine((10, 12), (7, 9))
            self.AddCollisionLine((7, 9), (9, 7))
            self.AddCollisionLine((9, 7), (12, 10))
            self.AddPOV(4, (11, 8), (4, 5))
            self.AddPOV(5, (7.5, 4.5), (5, 6))
            self.AddPOV(6, (4.5, 7.5), (6, 5))
            self.AddPOV(7, (8, 11), (7, 6))

            self.AddCollisionLine((10, -12), (7, -9))
            self.AddCollisionLine((7, -9), (9, -7))
            self.AddCollisionLine((9, -7), (12, -10))
            self.AddPOV(8, (11, -8), (8, 9))
            self.AddPOV(9, (7.5, -4.5), (9, 10))
            self.AddPOV(10, (4.5, -7.5), (10, 9))
            self.AddPOV(11, (8, -11), (11, 10))

            self.AddCollisionLine((-10, -12), (-7, -9))
            self.AddCollisionLine((-7, -9), (-9, -7))
            self.AddCollisionLine((-9, -7), (-12, -10))
            self.AddPOV(12, (-11, -8), (12, 13))
            self.AddPOV(13, (-7.5, -4.5), (13, 14))
            self.AddPOV(14, (-4.5, -7.5), (14, 13))
            self.AddPOV(15, (-8, -11), (15, 14))

            self.AddCollisionLine((-10, 12), (-7, 9))
            self.AddCollisionLine((-7, 9), (-9, 7))
            self.AddCollisionLine((-9, 7), (-12, 10))
            self.AddPOV(16, (-11, 8), (16, 17))
            self.AddPOV(17, (-7.5, 4.5), (17, 18))
            self.AddPOV(18, (-4.5, 7.5), (18, 17))
            self.AddPOV(19, (-8, 11), (19, 18))

        #After 2 minutes activate flippers

        #Change indicator lights to green
        if self.floormaster == 329:
            plus.playSound(self.activatesound)
            self.RemoveXtra("Obstacle")

            #Check if there are any heavyweights in the battle, if so, increase flipper power
            if plus.getWeight(0) > 650 or plus.getWeight(1) > 650 or plus.getWeight(2) > 650 or plus.getWeight(3) > 650:
                self.flipperpower = 2000
            else:
                self.flipperpower = 1250

        if self.floormaster > 329:
            #Check if bots are on NE flipper
            if plus.getLocation(0)[0] > 8 and plus.getLocation(0)[0] < 12 and plus.getLocation(0)[2] > 8 and plus.getLocation(0)[2] < 12 and plus.getLocation(0)[1] < -0.25:
                self.player1inne = 1
            else:
                self.player1inne = 0

            if plus.getLocation(1)[0] > 8 and plus.getLocation(1)[0] < 12 and plus.getLocation(1)[2] > 8 and plus.getLocation(1)[2] < 12 and plus.getLocation(1)[1] < -0.25:
                self.player2inne = 1
            else:
                self.player2inne = 0

            if plus.getLocation(2)[0] > 8 and plus.getLocation(2)[0] < 12 and plus.getLocation(2)[2] > 8 and plus.getLocation(2)[2] < 12 and plus.getLocation(2)[1] < -0.25:
                self.player3inne = 1
            else:
                self.player3inne = 0

            if plus.getLocation(3)[0] > 8 and plus.getLocation(3)[0] < 12 and plus.getLocation(3)[2] > 8 and plus.getLocation(3)[2] < 12 and plus.getLocation(3)[1] < -0.25:
                self.player4inne = 1
            else:
                self.player4inne = 0

            #Check if bots are on SE flipper
            if plus.getLocation(0)[0] > 8 and plus.getLocation(0)[0] < 12 and plus.getLocation(0)[2] < -8 and plus.getLocation(0)[2] > -12 and plus.getLocation(0)[1] < -0.25:
                self.player1inse = 1
            else:
                self.player1inse = 0

            if plus.getLocation(1)[0] > 8 and plus.getLocation(1)[0] < 12 and plus.getLocation(1)[2] < -8 and plus.getLocation(1)[2] > -12 and plus.getLocation(1)[1] < -0.25:
                self.player2inse = 1
            else:
                self.player2inse = 0

            if plus.getLocation(2)[0] > 8 and plus.getLocation(2)[0] < 12 and plus.getLocation(2)[2] < -8 and plus.getLocation(2)[2] > -12 and plus.getLocation(2)[1] < -0.25:
                self.player3inse = 1
            else:
                self.player3inse = 0

            if plus.getLocation(3)[0] > 8 and plus.getLocation(3)[0] < 12 and plus.getLocation(3)[2] < -8 and plus.getLocation(3)[2] > -12 and plus.getLocation(3)[1] < -0.25:
                self.player4inse = 1
            else:
                self.player4inse = 0

            #Check if bots are on SW flipper
            if plus.getLocation(0)[0] < -8 and plus.getLocation(0)[0] > -12 and plus.getLocation(0)[2] < -8 and plus.getLocation(0)[2] > -12 and plus.getLocation(0)[1] < -0.25:
                self.player1insw = 1
            else:
                self.player1insw = 0

            if plus.getLocation(1)[0] < -8 and plus.getLocation(1)[0] > -12 and plus.getLocation(1)[2] < -8 and plus.getLocation(1)[2] > -12 and plus.getLocation(1)[1] < -0.25:
                self.player2insw = 1
            else:
                self.player2insw = 0

            if plus.getLocation(2)[0] < -8 and plus.getLocation(2)[0] > -12 and plus.getLocation(2)[2] < -8 and plus.getLocation(2)[2] > -12 and plus.getLocation(2)[1] < -0.25:
                self.player3insw = 1
            else:
                self.player3insw = 0

            if plus.getLocation(3)[0] < -8 and plus.getLocation(3)[0] > -12 and plus.getLocation(3)[2] < -8 and plus.getLocation(3)[2] > -12 and plus.getLocation(3)[1] < -0.25:
                self.player4insw = 1
            else:
                self.player4insw = 0

            #Check if bots are on NW flipper
            if plus.getLocation(0)[0] < -8 and plus.getLocation(0)[0] > -12 and plus.getLocation(0)[2] > 8 and plus.getLocation(0)[2] < 12 and plus.getLocation(0)[1] < -0.25:
                self.player1innw = 1
            else:
                self.player1innw = 0

            if plus.getLocation(1)[0] < -8 and plus.getLocation(1)[0] > -12 and plus.getLocation(1)[2] > 8 and plus.getLocation(1)[2] < 12 and plus.getLocation(1)[1] < -0.25:
                self.player2innw = 1
            else:
                self.player2innw = 0

            if plus.getLocation(2)[0] < -8 and plus.getLocation(2)[0] > -12 and plus.getLocation(2)[2] > 8 and plus.getLocation(2)[2] < 12 and plus.getLocation(2)[1] < -0.25:
                self.player3innw = 1
            else:
                self.player3innw = 0

            if plus.getLocation(3)[0] < -8 and plus.getLocation(3)[0] > -12 and plus.getLocation(3)[2] > 8 and plus.getLocation(3)[2] < 12 and plus.getLocation(3)[1] < -0.25:
                self.player4innw = 1
            else:
                self.player4innw = 0

            if self.player1inne == 1 or self.player2inne == 1 or self.player3inne == 1 or self.player4inne == 1:
                self.botinne = 1

            if self.player1inse == 1 or self.player2inse == 1 or self.player3inse == 1 or self.player4inse == 1:
                self.botinse = 1

            if self.player1insw == 1 or self.player2insw == 1 or self.player3insw == 1 or self.player4insw == 1:
                self.botinsw = 1

            if self.player1innw == 1 or self.player2innw == 1 or self.player3innw == 1 or self.player4innw == 1:
                self.botinnw = 1

            #Fire NE flipper
            if self.botinne == 1:
                self.nefliptimer += 1

            if self.nefliptimer == 2:
                plus.playSound(self.flippersound)
                self.neflipper.SetPowerSettings(40,self.flipperpower)
                self.neflipper.Lock(False)
                self.neflipper.SetDirection(100)
            if self.nefliptimer == 6:
                plus.playSound(self.flippersound2)
                self.neflipper.SetPowerSettings(4,200)
                self.neflipper.Lock(False)
                self.neflipper.SetDirection(-100)
                self.botinne = 0
                self.nefliptimer = 0

            #Fire SE flipper
            if self.botinse == 1:
                self.sefliptimer += 1

            if self.sefliptimer == 2:
                plus.playSound(self.flippersound)
                self.seflipper.SetPowerSettings(40,self.flipperpower)
                self.seflipper.Lock(False)
                self.seflipper.SetDirection(100)
            if self.sefliptimer == 6:
                plus.playSound(self.flippersound2)
                self.seflipper.SetPowerSettings(4,200)
                self.seflipper.Lock(False)
                self.seflipper.SetDirection(-100)
                self.botinse = 0
                self.sefliptimer = 0

            #Fire SW flipper
            if self.botinsw == 1:
                self.swfliptimer += 1

            if self.swfliptimer == 2:
                plus.playSound(self.flippersound)
                self.swflipper.SetPowerSettings(40,self.flipperpower)
                self.swflipper.Lock(False)
                self.swflipper.SetDirection(100)
            if self.swfliptimer == 6:
                plus.playSound(self.flippersound2)
                self.swflipper.SetPowerSettings(4,200)
                self.swflipper.Lock(False)
                self.swflipper.SetDirection(-100)
                self.botinsw = 0
                self.swfliptimer = 0

            #Fire NW flipper
            if self.botinnw == 1:
                self.nwfliptimer += 1

            if self.nwfliptimer == 2:
                plus.playSound(self.flippersound)
                self.nwflipper.SetPowerSettings(40,self.flipperpower)
                self.nwflipper.Lock(False)
                self.nwflipper.SetDirection(100)
            if self.nwfliptimer == 6:
                plus.playSound(self.flippersound2)
                self.nwflipper.SetPowerSettings(4,200)
                self.nwflipper.Lock(False)
                self.nwflipper.SetDirection(-100)
                self.botinnw = 0
                self.nwfliptimer = 0

            ##################  BotFlame ##################-------------
        if self.SetDefaultstimer == 0: #### Set these random values at start. 
            self.RI_OffOrOn = randint(1, self.FrequencyOfBotFire) # @@ Turns Bot flames "On" average of parameter set above (_init_) . @@@@@@
            self.RI_1 = randint(-2, 2) # For flame angle (x, z).
            self.RI_2 = randint(-2, 2)
            self.RI_3 = randint(-2, 2)
            self.RI_4 = randint(-2, 2)
            self.RI_5 = randint(1, 2) # For flame height (y).
            self.RI_6 = randint(1, 2) 
            self.SetDefaultstimer +=1 #### Valid only for 1st Tick, then effectively "OFF".

        #----- Damage = Fire -----
        if self.BOT_0 == True:
            if plus.getHealth(0,0) < self.DamageUntilFlame_a and self.RI_OffOrOn == 1:
                self.flame0a.BotFlameOff()
                self.flame0a = HazardsBlueRay.BotFlame(plus.getLocation(0), (self.RI_1, self.RI_5, self.RI_2), (.2, .4, .2), .8)
                if self.FireDamageON == True:
                    plus.damage(0, 0, self.FireDamageAmount, plus.getLocation(0)) #  damage to bot-0
                if self.FireSoundON == True:
                    plus.playSound(self.Crackle)
                self.flame0a.BotFlameOn()

        if self.BOT_1 == True:
            if plus.getHealth(1,0) < self.DamageUntilFlame_a and self.RI_OffOrOn == 1:
                self.flame1a.BotFlameOff()
                self.flame1a = HazardsBlueRay.BotFlame(plus.getLocation(1), (self.RI_2, self.RI_6, self.RI_3), (.2, .4, .2), .8)
                if self.FireDamageON == True:
                    plus.damage(1, 0, self.FireDamageAmount, plus.getLocation(1)) #  damage to bot-1
                if self.FireSoundON == True:
                    plus.playSound(self.Crackle)
                self.flame1a.BotFlameOn()

        if self.BOT_2 ==True:
            if plus.getHealth(2,0) < self.DamageUntilFlame_a and self.RI_OffOrOn == 1:
                self.flame2a.BotFlameOff()
                self.flame2a = HazardsBlueRay.BotFlame(plus.getLocation(2), (self.RI_3, self.RI_5, self.RI_4), (.2, .4, .2), .8)
                if self.FireDamageON == True:
                    plus.damage(2, 0, self.FireDamageAmount, plus.getLocation(2)) #  damage to bot-2
                if self.FireSoundON == True:
                    plus.playSound(self.Crackle)
                self.flame2a.BotFlameOn()

        if self.BOT_3 == True:
            if plus.getHealth(3,0) < self.DamageUntilFlame_a and self.RI_OffOrOn == 1:
                self.flame3a.BotFlameOff()
                self.flame3a = HazardsBlueRay.BotFlame(plus.getLocation(3), (self.RI_4, self.RI_6, self.RI_1), (.2, .4, .2), .8)
                if self.FireDamageON == True:
                    plus.damage(3, 0, self.FireDamageAmount, plus.getLocation(3)) #  damage to bot-3
                if self.FireSoundON == True:
                    plus.playSound(self.Crackle)
                self.flame3a.BotFlameOn()

        #----- If More Damage, then More Fire -----
        if self.BOT_0 == True:
            if plus.getHealth(0,0) < self.DamageUntilFlame_b and self.RI_OffOrOn == 1:
                self.flame0b.BotFlameOff()
                self.flame0b = HazardsBlueRay.BotFlame(plus.getLocation(0), (self.RI_2, self.RI_6, self.RI_1), (.2, .4, .2), .8)
                self.flame0b.BotFlameOn()

        if self.BOT_1 == True:
            if plus.getHealth(1,0) < self.DamageUntilFlame_b and self.RI_OffOrOn == 1:
                self.flame1b.BotFlameOff()
                self.flame1b = HazardsBlueRay.BotFlame(plus.getLocation(1), (self.RI_3, self.RI_5, self.RI_2), (.2, .4, .2), .8)
                self.flame1b.BotFlameOn()

        if self.BOT_2 == True:
            if plus.getHealth(2,0) < self.DamageUntilFlame_b and self.RI_OffOrOn == 1:
                self.flame2b.BotFlameOff()
                self.flame2b = HazardsBlueRay.BotFlame(plus.getLocation(2), (self.RI_4, self.RI_6, self.RI_3), (.2, .4, .2), .8)
                self.flame2b.BotFlameOn()

        if self.BOT_3 == True:
            if plus.getHealth(3,0) < self.DamageUntilFlame_b and self.RI_OffOrOn == 1:
                self.flame3b.BotFlameOff()
                self.flame3b = HazardsBlueRay.BotFlame(plus.getLocation(3), (self.RI_1, self.RI_5, self.RI_4), (.2, .4, .2), .8)
                self.flame3b.BotFlameOn()
            ##################  BotFlame ##################-------------

            
        return Arenas.SuperArena.Tick(self)
        
Arenas.register(BBEANS_2)